using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace cifXTest
{
    public partial class cifXAppReady : Form
    {
        private cifXUser cifXUser = new cifXUser();
        private cifxBase cifXBase = new cifxBase();

        private UInt32 pulState = 0;

        public cifXAppReady()
        {
            InitializeComponent();
            this.cmbNewState.Items.Add("Application NOT Ready");
            this.cmbNewState.Items.Add("Application Ready");
            this.cmbNewState.SelectedIndex = 0;
            this.txtTimeout.Text = "0";

            GetAppStatus();

        }

        private void GetAppStatus()
        {
            UInt32 lret = 0;
            UInt32 ulTimeout = (UInt32)Convert.ToInt32(this.txtTimeout.Text);

            lret = cifXUser.xChannelHostState(cifXUser.CIFX_HOST_STATE_READ, ref pulState, ulTimeout);
            if (pulState == cifXUser.CIFX_HOST_STATE_NOT_READY)
                this.txtActState.Text = "Application NOT Ready";
            else
                this.txtActState.Text = "Application Ready";

            this.txtError.Text = cifXBase.SetLastError(lret);
        }

        private void SetAppStatus()
        {
            UInt32  lret        = 0;
            UInt32  ulTimeout   = (UInt32)Convert.ToInt32(this.txtTimeout.Text);
            int     iSetStatus  = this.cmbNewState.SelectedIndex;

            if (iSetStatus == 0)
                cifXUser.xChannelHostState(cifXUser.CIFX_HOST_STATE_NOT_READY, ref pulState, ulTimeout);
            else
                cifXUser.xChannelHostState(cifXUser.CIFX_HOST_STATE_READY, ref pulState, ulTimeout);

            GetAppStatus();
            this.txtError.Text = cifXBase.SetLastError(lret);
        }

        private void btnGetAppState_Click(object sender, EventArgs e)
        {
            GetAppStatus();
        }

        private void btnSetAppState_Click(object sender, EventArgs e)
        {
            SetAppStatus();
        }
    }
}